% finaquant Financial Analytics - www.finaquant.com
% Copyright: Tunc Ali Ktkcoglu  2012, version: 28Mar2012
% TITLE: Simple Performance Fee Calculation
% Related web page:
% http://finaquant.com/simple-performance-fee-calculation-for-investment-funds/760

% generate vectors NAVps and benchmark returns
N = 50;  % vector length
x =1:N;
y = 1:N+1;
InitialNAVps = 10;

% hypothetical benchmark returns
BenchmarkReturns = 0.02 + 0.03 * sin((x+5)*2*pi/(N/4)) .* sqrt(1 + x/N) / sqrt(2);

% construct benchmark values
BenchmarkValues = convert_Returns_to_AssetValues(InitialNAVps, BenchmarkReturns);

% hypothetical fund returns and NAVps
FundReturns = 0.02 + BenchmarkReturns + 0.03 * sin((x-5)*2*pi/(N/6));
NAVps = convert_Returns_to_AssetValues(InitialNAVps, FundReturns);

% plot fund returns against benchmark returns
plot(x,FundReturns,'blue',x,BenchmarkReturns,'red');
title('fund returns (blue) vs benchmark returns (red)')
xlabel('time (periods)')
ylabel('return')
figure

% plot NAVps against benchmark values
plot(y,NAVps,'blue',y,BenchmarkValues,'red');
title('fund NAVps (blue) vs benchmark values (red)')
xlabel('time (periods)')
ylabel('asset value')
figure

disp('***********************************************************************')
disp('Big test')
disp('***********************************************************************')
% input parameters
FeeRate = 0.20;
HurdleRate = 0.01;
applyHWM = false;
FloorPs = -999999999;   % set to -999999999 for no floor
CapPs = 999999999;      % set to 999999999 for no cap

% run simple performance fee function
[Outperform,FundReturn,ExcessReturn,RelativeValues,rHWM,FeeBeforeCF,PerfFeePs] = SimplePerformanceFee(NAVps,BenchmarkReturns,applyHWM,FeeRate,HurdleRate,FloorPs,CapPs);

% total performance fee paid over all periods
TotalPerfFeePaid = sum(PerfFeePs)

% plot excess return and performance fee per share
plot(x,ExcessReturn,'blue',x,PerfFeePs,'red');
title('excess return (blue) vs performance fee ps (red)')
xlabel('time (periods)')
ylabel('% and $')

disp('***********************************************************************')
disp('Simple test')
disp('***********************************************************************')
% input parameters
NAVps = [100 110 120 130];
BenchmarkReturns = [0 0 0];
FeeRate = 0.20;
HurdleRate = 0.01;
applyHWM = false;
FloorPs = -999999999;   % set to -999999999 for no floor
CapPs = 999999999;      % set to 999999999 for no cap

% run simple performance fee function
[Outperform,FundReturn,ExcessReturn,RelativeValues,rHWM,FeeBeforeCF,PerfFeePs] = SimplePerformanceFee(NAVps,BenchmarkReturns,applyHWM,FeeRate,HurdleRate,FloorPs,CapPs);

% total performance fee paid over all periods
TotalPerfFeePaid_test = sum(PerfFeePs)


